% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualiseTree.R
\name{colourTree}
\alias{colourTree}
\title{colourTree}
\usage{
colourTree(
  tree,
  point_size = 1.5,
  high = "#00c434",
  low = "purple",
  mid = "ivory2"
)
}
\arguments{
\item{tree}{a tree plot created from the ggtree() function
with p$data containing test statisic and p-}

\item{point_size}{size of nodes in the tree}

\item{high}{colour for large values}

\item{low}{colour for low values}

\item{mid}{colour for middle values}
}
\value{
an interactive ggplot graph object, plotting the hierarchical
tree of clusters with nodes and branches coloured by the significance testing results.
}
\description{
Adding statistical test results onto the tree by using
colourful nodes and branches
Takes a ggtree object with test results for each node and returns
a ggtree graph object
}
\examples{
library(SingleCellExperiment)
data(COVIDSampleData)

sce <- DeBiasi_COVID_CD8_samp
exprs <- t(assay(sce, "exprs"))
clusters <- colData(sce)$cluster_id
classes <- colData(sce)$condition
samples <- colData(sce)$sample_id

clust_tree <- getClusterTree(exprs,
                             clusters,
                             hierarchy_method="hopach")

tested_tree <- testTree(clust_tree$clust_tree,
                        clusters=clusters,
                        samples=samples,
                        classes=classes)

colourTree(tested_tree)
}
