% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridClassify.R
\name{gridClassify}
\alias{gridClassify}
\alias{gridClassify,data.frame-method}
\alias{gridClassify,ddpcrWell-method}
\alias{gridClassify,ddpcrPlate-method}
\title{Use a 'grid' to create training data for classification algorithms.}
\usage{
gridClassify(
  droplets,
  ch1NNThreshold = 6500,
  ch2NNThreshold = 1900,
  ch1NPThreshold = 6500,
  ch2NPThreshold = 5000,
  ch1PNThreshold = 10000,
  ch2PNThreshold = 2900,
  ch1PPThreshold = 7500,
  ch2PPThreshold = 5000,
  ...
)

\S4method{gridClassify}{data.frame}(
  droplets,
  ch1NNThreshold = 6500,
  ch2NNThreshold = 1900,
  ch1NPThreshold = 6500,
  ch2NPThreshold = 5000,
  ch1PNThreshold = 10000,
  ch2PNThreshold = 2900,
  ch1PPThreshold = 7500,
  ch2PPThreshold = 5000,
  trainingData = TRUE,
  fullTable = TRUE,
  naLabel = ddpcr$rain
)

\S4method{gridClassify}{ddpcrWell}(
  droplets,
  ch1NNThreshold = 6500,
  ch2NNThreshold = 1900,
  ch1NPThreshold = 6500,
  ch2NPThreshold = 5000,
  ch1PNThreshold = 10000,
  ch2PNThreshold = 2900,
  ch1PPThreshold = 7500,
  ch2PPThreshold = 5000,
  classMethodLabel = "grid",
  naLabel = ddpcr$rain
)

\S4method{gridClassify}{ddpcrPlate}(
  droplets,
  ch1NNThreshold = 6500,
  ch2NNThreshold = 1900,
  ch1NPThreshold = 6500,
  ch2NPThreshold = 5000,
  ch1PNThreshold = 10000,
  ch2PNThreshold = 2900,
  ch1PPThreshold = 7500,
  ch2PPThreshold = 5000,
  classMethodLabel = "grid",
  naLabel = ddpcr$rain
)
}
\arguments{
\item{droplets}{A \code{\link{ddpcrWell}} object or a data frame of droplet
amplitudes with columns \code{Ch1.Amplitude} and \code{Ch2.Amplitude}.}

\item{ch1NNThreshold}{The channel 1 upper bound for the NN class. Defaults
to 6500.}

\item{ch2NNThreshold}{The channel 2 upper bound for the NN class. Defaults
to 1900.}

\item{ch1NPThreshold}{The channel 1 upper bound for the NP class. Defaults
to 6500.}

\item{ch2NPThreshold}{The channel 2 lower bound for the NP class. Defaults
to 5000.}

\item{ch1PNThreshold}{The channel 1 lower bound for the PN class. Defaults
to 10000.}

\item{ch2PNThreshold}{The channel 2 upper bound for the PN class. Defaults
to 2900.}

\item{ch1PPThreshold}{The channel 1 lower bound for the PP class. Defaults
to 7500.}

\item{ch2PPThreshold}{The channel 2 lower bound for the PP class. Defaults
to 5000.}

\item{...}{Other options depending on the type of \code{droplets}.}

\item{trainingData}{Whether to use the output as training data. If
\code{TRUE}, returns the _full table_ with the "N/A" entries removed; if
\code{FALSE}, the "N/A" entries are retained. Taken to be \code{FALSE} if
\code{fullTable} is set to \code{FALSE}. Defaults to \code{TRUE}. Ignored
if \code{droplets} is not a data frame.}

\item{fullTable}{Whether to return a data frame including amplitude
figures. If \code{TRUE}, a data frame with columns \code{Ch1.Amplitude},
\code{Ch1.Amplitude} and \code{class} is returned. If \code{FALSE}, a factor
with levels in \code{ddpcr$classesRain} is returned, where each entry
corresponds to each row in \code{droplets} (and \code{trainingData} is
automatically set to \code{FALSE}). Defaults to \code{TRUE}. Ignored if
\code{droplets} is not a data frame.}

\item{naLabel}{The label to use for unclassified droplets. Should be either
ddpcr$na ("N/A") or ddpcr$rain ("Rain"). Defaults to ddpcr$rain.}

\item{classMethodLabel}{A name (as a character string) of the classification
method. Defaults to "grid".}
}
\value{
If \code{droplets} is a data frame, return a data frame or factor
(depending on the \code{trainingData} and \code{fullTable} parameters) with
a classification for droplets in the chosen regions.

If \code{droplets} is a \code{ddpcrWell} object, return
a \code{ddpcrWell} object with the appropriate classification.

If \code{droplets} is a \code{ddpcrPlate} object, return
a \code{ddpcrPlate} object with the appropriate classification.
}
\description{
Classify droplets as "NN", "NP", "PN" or "PP". The
classification is based on upper bounds for negative readings and lower
bounds for positive readings; see the details and parameters for more
detail. If required (see the \code{trainingData} parameter), droplets that
are not classified will be given the label "N/A".
}
\details{
The \code{threshold} parameters correspond to those in the
following diagram:
\preformatted{Ch1 ^        |  |
    |        |  |
    |   PN   |  |
    |        |  |   PP
   e|________|  |
   g|........:..|_________
    |        :  :
   c|.............._______
   a|______  :  : |
    |      | :  : |  NP
    |  NN  | :  : |
    |      | :  : |
    --------------------->
           b f  h d    Ch2}
Specifically:
\describe{
  \item{a:}{\code{ch1NNThreshold},}
  \item{b:}{\code{ch2NNThreshold},}
  \item{c:}{\code{ch1PNThreshold},}
  \item{d:}{\code{ch2PNThreshold},}
  \item{e:}{\code{ch1NPThreshold},}
  \item{f:}{\code{ch2NPThreshold},}
  \item{g:}{\code{ch1PPThreshold},}
  \item{h:}{\code{ch2PPThreshold}.}
}
}
\examples{
## Use a grid to set training data for a data frame.
sgCl <- gridClassify(KRASdata[["E03"]],
                     ch1NNThreshold=5700, ch2NNThreshold=1700,
                     ch1NPThreshold=5400, ch2NPThreshold=5700,
                     ch1PNThreshold=9700, ch2PNThreshold=2050,
                     ch1PPThreshold=7200, ch2PPThreshold=4800)
str(sgCl)

## For data frame only, we can set the trainingData flag to FALSE so that
## the unclassified droplets are retained but labelled as "N/A"
sgCl <- gridClassify(KRASdata[["E03"]],
                     ch1NNThreshold=5700, ch2NNThreshold=1700,
                     ch1NPThreshold=5400, ch2NPThreshold=5700,
                     ch1PNThreshold=9700, ch2PNThreshold=2050,
                     ch1PPThreshold=7200, ch2PPThreshold=4800,
                     trainingData=FALSE)
dropletPlot(sgCl, cMethod="class")

## The same works for ddpcrWell objects.
aWell <- ddpcrWell(well=KRASdata[["E03"]])
aWell <- gridClassify(aWell,
                      ch1NNThreshold=5700, ch2NNThreshold=1700,
                      ch1NPThreshold=5400, ch2NPThreshold=5700,
                      ch1PNThreshold=9700, ch2PNThreshold=2050,
                      ch1PPThreshold=7200, ch2PPThreshold=4800)
str(aWell)

## ddpcrPlate objects work in exactly the same way.
krasPlate <- ddpcrPlate(wells=KRASdata)
krasPlate <- gridClassify(krasPlate)
lapply(plateClassification(krasPlate, withAmplitudes=TRUE), head, n=1)

## The default classification method (column name) is 'gridClassify',
## which may be a bit long. It can be changed.
krasPlate <- gridClassify(krasPlate, classMethodLabel="training")
lapply(plateClassification(krasPlate, withAmplitudes=TRUE), head, n=1)

}
\seealso{
\code{\link{thresholdClassify}} is a special case of this
function.

\code{\link{removeDropletClasses}} retrieves a data frame with the
"N/A" (and "Rain") droplets removed. This can used for transforming
a grid-like classification into usable training data.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
