% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_motifs.R
\name{view_motifs}
\alias{view_motifs}
\title{Plot motif logos.}
\usage{
view_motifs(motifs, use.type = "ICM", method = "ALLR", tryRC = TRUE,
  min.overlap = 6, min.mean.ic = 0.25, relative_entropy = FALSE,
  normalise.scores = FALSE, min.position.ic = 0, score.strat = "sum",
  return.raw = FALSE, dedup.names = TRUE, show.positions = TRUE,
  show.positions.once = TRUE, show.names = TRUE, names.pos = c("top",
  "right"), use.freq = 1, colour.scheme = NULL, fontDF = NULL,
  min.height = 0.01, x.spacer = if (use.freq == 1) 0.04 else 0.1,
  y.spacer = 0.01, sort.positions = !use.type \%in\% c("PCM", "PPM"),
  sort.positions.decreasing = TRUE, text.size = 16, fit.to.height = if
  (use.type == "PPM") 1 else NULL, RC.text = " [RC]", flip.neg = FALSE,
  ...)
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable motif formats.}

\item{use.type}{\code{character(1)} One of \code{c('PCM', 'PPM', 'PWM', 'ICM')}.}

\item{method}{\code{character(1)} One of PCC, EUCL, SW, KL, ALLR, BHAT, HELL,
SEUCL, MAN, ALLR_LL, WEUCL, WPCC. See details.}

\item{tryRC}{\code{logical(1)} Try the reverse complement of the motifs as well,
report the best score.}

\item{min.overlap}{\code{numeric(1)} Minimum overlap required when aligning the
motifs. Setting this to a number higher then the width of the motifs
will not allow any overhangs. Can also be a number between 0 and 1,
representing the minimum fraction that the motifs must overlap.}

\item{min.mean.ic}{\code{numeric(1)} Minimum mean information content between the
two motifs for an alignment to be scored. This helps prevent scoring
alignments between low information content regions of two motifs. Note that
this can result in some comparisons failing if no alignment passes the
mean IC threshold. Use \code{\link[=average_ic]{average_ic()}} to filter out low IC motifs to get around
this if you want to avoid getting \code{NA}s in your output.}

\item{relative_entropy}{\code{logical(1)} Change the ICM calculation affecting
\code{min.position.ic} and \code{min.mean.ic}. See \code{\link[=convert_type]{convert_type()}}.}

\item{normalise.scores}{\code{logical(1)} Favour alignments which leave fewer
unaligned positions, as well as alignments between motifs of similar length.
Similarity scores are multiplied by the ratio of
aligned positions to the total number of positions in the larger motif,
and the inverse for distance scores.}

\item{min.position.ic}{\code{numeric(1)} Minimum information content required between
individual alignment positions for it to be counted in the final alignment
score. It is recommended to use this together with \code{normalise.scores = TRUE},
as this will help punish scores resulting from only a fraction of an
alignment.}

\item{score.strat}{\code{character(1)} How to handle column scores calculated from
motif alignments. "sum": add up all scores. "a.mean": take the arithmetic
mean. "g.mean": take the geometric mean. "median": take the median.
"wa.mean", "wg.mean": weighted arithmetic/geometric mean. "fzt": Fisher
Z-transform. Weights are the
total information content shared between aligned columns.}

\item{return.raw}{\code{logical(1)} Instead of returning a plot, return the
aligned named matrices used to generate the plot. This can be useful
if you wish to use \code{\link[=view_motifs]{view_motifs()}} alignment capabilities for custom
plotting uses. Alignment is performed by adding empty columns to the
left or right of motifs to generate matrices of equal length.}

\item{dedup.names}{\code{logical(1)} Plotting motifs with duplicated names is
not allowed. Setting this to \code{TRUE} allows the names to be modified
for plotting.}

\item{show.positions}{\code{logical(1)} Show x-axis position tick labels.}

\item{show.positions.once}{\code{logical(1)} When plotting multiple motifs,
show x-axis position tick labels only once. If \code{FALSE}, then
x-axis tick labels are specific to each motif.}

\item{show.names}{\code{logical(1)} Add motif names when plotting multiple
motifs.}

\item{names.pos}{\code{character(1)} Motif name locations. Either above (\code{top})
or to the right (\code{right}) of the logos.}

\item{use.freq}{\code{numeric(1)} Plot higher order motifs from the \code{multifreq}
slot.}

\item{colour.scheme}{\code{character} A named character vector of colour names.
Default colours are provided for DNA, RNA, and AA motifs if left \code{NULL}.}

\item{fontDF}{\code{data.frame} or \code{DataFrame} Polygon data for letters used
for plotting, as generated by the \code{createPolygons()} function from the
\code{gglogo} package. See the \code{fontDFroboto} data object (which is used
by default when \code{fontDF = NULL}). See \code{Examples} for how to generate
your own font set. Expected columns: \code{x}, \code{y}, \code{order}, \code{group};
additional columns will be ignored.}

\item{min.height}{\code{numeric(1)} Minimum height for a letter to be plotted.
The number is taken as the fraction of the total height of the plot.
The default value is to not show letters which take up 1\% or less of the
vertical space. For smaller figures it is recommended to increase this
value, and vice versa for larger figures.}

\item{x.spacer}{\code{numeric(1)} Add horizontal spacing between letters. The
number is taken as the fraction of the width of an individual position.
Increasing this value is recommended for plotting multifreq motifs.}

\item{y.spacer}{\code{numeric(1)} Add vertical spacing between letters. The
number is taken as the fraction nof the total height of the plot.}

\item{sort.positions}{\code{logical(1)} Sort letters vertically per position
by height.}

\item{sort.positions.decreasing}{\code{logical(1)} Sort in decreasing or
increasing order based on letter height.}

\item{text.size}{\code{numeric(1)} Text size for labels.}

\item{fit.to.height}{\code{numeric(1)} Normalize the per position height to
this value. If \code{NULL}, no normalization is applied. Note that this
parameter is ignored if \code{use.type = c("PWM", "ICM")}.}

\item{RC.text}{\code{character(1)} The text to display alongside the name
of motifs shown as their reverse complement.}

\item{flip.neg}{\code{logical(1)} Flip letters with negative heights.}

\item{...}{Unused. Was previously in place to allow extra args to be given
to \code{ggseqlogo::ggseqlogo}, however \code{universalmotif} now implements its
own motif plotting code directly with \code{ggplot2}.}
}
\value{
A \code{ggplot} object. If \code{return.raw = TRUE}, a list of matrices.
}
\description{
Show sequence logo. If given a list of more than one motif, then the motifs
are aligned with the first in the list.
}
\details{
See \code{\link[=compare_motifs]{compare_motifs()}} for more info on comparison parameters.

See \code{\link[=view_logo]{view_logo()}} to plot from a numeric matrix with arbitrary values instead
of a motif object.

Note: \code{score.strat = "a.mean"} is NOT recommended, as \code{\link[=view_motifs]{view_motifs()}} will
not discriminate between two alignments with equal mean scores, even if one
alignment is longer than the other.

Note: if you want to plot the motifs yourself, you can set
\code{return.raw=TRUE} to get the numeric motif matrices and calculate
the polygon paths on your own or access the polygon path data directly from
the final \code{ggplot} object using \verb{$data}.
}
\examples{
## Plotting multifreq motifs:
data(examplemotif2)
view_motifs(examplemotif2, use.freq = 2)

## Generate your own letter set:
\dontrun{

library(gglogo)  # install from CRAN first if needed
fontDFtimes <- createPolygons(LETTERS, "Times", 800, scale = TRUE)
view_motifs(examplemotif2, fontDF = fontDFtimes)

## Note: setting `scale = TRUE` is necessary to properly align letters
## vertically, but this has the effect of horizontally stretching out
## letters which shouldn't be stretched (such as "I"). If you need to plot
## letters which have been badly horizontally scaled, you can fix them
## manually as demonstrated here:

# Retrieve the x-coordinates for the desired letter:
tofix <- fontDFtimes$x[fontDFtimes$group == "I"]
# Scale the letter x-coordinates:
tofix <- tofix * 0.35
# Remember to center the letter around 0.5 again:
tofix <- tofix + (1 - max(tofix)) / 2
# Apply the fix:
fontDFtimes$x[fontDFtimes$group == "I"] <- tofix
view_motifs(create_motif("AIG", alphabet = "AA"), fontDF = fontDFtimes)

}

}
\seealso{
\code{\link[=compare_motifs]{compare_motifs()}}, \code{\link[=add_multifreq]{add_multifreq()}}, \code{\link[=view_logo]{view_logo()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
