% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsVolcanoMatrix.R
\name{vsVolcanoMatrix}
\alias{vsVolcanoMatrix}
\title{Volcano plot matrix from \eqn{log_{2}} fold changes and
\eqn{-log_{10}}(\eqn{p}-values)}
\usage{
vsVolcanoMatrix(
  data,
  d.factor = NULL,
  type = c("cuffdiff", "deseq", "edger"),
  padj = 0.05,
  x.lim = NULL,
  lfc = NULL,
  title = TRUE,
  legend = TRUE,
  grid = TRUE,
  counts = TRUE,
  data.return = FALSE,
  xaxis.text.size = 9,
  yaxis.text.size = 9,
  xaxis.title.size = 10,
  yaxis.title.size = 10,
  main.title.size = 15,
  legend.text.size = 9,
  facet.title.size = 10
)
}
\arguments{
\item{data}{a cuffdiff, DESeq2, or edgeR object.}

\item{d.factor}{a specified factor; for use with DESeq2 objects only.
Defaults to \code{NULL}}

\item{type}{an analysis classifier to tell the function how to process the
data. Must be either \code{cuffdiff}, \code{deseq}, or \code{edgeR}.}

\item{padj}{a user defined adjusted \eqn{p}-value cutoff point.
Defaults to \code{0.05}.}

\item{x.lim}{set manual limits to the x axis. Defaults to \code{NULL}.}

\item{lfc}{\eqn{log} fold change level for setting conditonals. If no user
input is added (\code{NULL}), value defaults to \code{1}.}

\item{title}{show title of plot. Defaults to \code{TRUE}.}

\item{legend}{shows legend of plot. Defaults to \code{TRUE}.}

\item{grid}{show major and minor axis lines. Defaults to \code{TRUE}.}

\item{counts}{displays the number of differentially expressed genes for
each treatment comparison. Defaults to \code{TRUE}.}

\item{data.return}{returns data output of plot if set to \code{TRUE}.
Defaults to \code{FALSE}.}

\item{xaxis.text.size}{change the font size of the \code{x}-axis text.
Defaults to \code{9}.}

\item{yaxis.text.size}{change the font size of the \code{y}-axis text.
Defaults to \code{9}.}

\item{xaxis.title.size}{change the font size of the \code{x}-axis title
text. Defaults to \code{10}.}

\item{yaxis.title.size}{change the font size of the \code{y}-axis title
text. Defaults to \code{10}.}

\item{main.title.size}{change the font size of the plot title text.
Defaults to \code{15}.}

\item{legend.text.size}{change the font size of the legend body text.
Defaults to \code{9}.}

\item{facet.title.size}{change the font size of the facet wrap title text.
Defaults to \code{10}.}
}
\value{
An object created by \code{ggplot}
}
\description{
This function allows you to extract necessary results-based data from
either a \code{DESeq2} object, \code{edgeR} object, or \code{cuffdiff} data
frame to create a volcano plot (i.e. a scatter plot) of the negative
\eqn{log} of the \eqn{p}-value versus the \eqn{log} of the fold change
while implementing ggplot2 aesthetics for all possible combinations of
treatments.
}
\examples{
# Cuffdiff example
data("df.cuff")
vsVolcanoMatrix(
     data = df.cuff, d.factor = NULL, type = "cuffdiff",
     padj = 0.05, x.lim = NULL, lfc = 2, title = TRUE,
     grid = TRUE, counts = TRUE, data.return = FALSE
)

# DESeq2 example
data("df.deseq")
require(DESeq2)
vsVolcanoMatrix(
     data = df.deseq, d.factor = "condition", type = "deseq",
     padj = 0.05, x.lim = NULL, lfc = 2, title = TRUE,
     grid = TRUE, counts = TRUE, data.return = FALSE
)

# edgeR example
data("df.edger")
require(edgeR)
vsVolcanoMatrix(
     data = df.edger, d.factor = NULL, type = "edger",
     padj = 0.05, x.lim = NULL, lfc = 2, title = TRUE,
     grid = TRUE, counts = TRUE, data.return = FALSE
)

# Extract data frame from visualization
data("df.cuff")
tmp <- vsVolcanoMatrix(
     data = df.cuff, d.factor = NULL,
     type = "cuffdiff", padj = 0.05, x.lim = NULL,
     lfc = 2, title = TRUE, grid = TRUE,
     counts = TRUE, data.return = TRUE
)
df_vmat <- tmp[[1]]
head(df_vmat)

# Show plot from object (see prior example for more details)
tmp[[2]] ## or use tmp$plot
}
\author{
Brandon Monier, \email{brandon.monier@sdstate.edu}
}
