% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viper.r
\name{aREA}
\alias{aREA}
\title{analytic Rank-based Enrichment Analysis}
\usage{
aREA(eset, regulon, method = c("auto", "matrix", "loop"), minsize = 20,
  cores = 1, wm = NULL, verbose = FALSE)
}
\arguments{
\item{eset}{Matrix containing a set of signatures, with samples in columns and traits in rows}

\item{regulon}{Regulon object}

\item{method}{Character string indicating the implementation, either auto, matrix or loop}

\item{minsize}{Interger indicating the minimum allowed size for the regulons}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{wm}{Optional numeric matrix of weights (0; 1) with same dimension as eset}

\item{verbose}{Logical, whether a progress bar should be shown}
}
\value{
List of two elements, enrichment score and normalized enrichment score
}
\description{
This function performs wREA enrichment analysis on a set of signatues
}
