% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinbwave.R
\name{computeObservationalWeights}
\alias{computeObservationalWeights}
\title{Observational weights of the zero-inflated negative binomial model for each entry
in the matrix of counts}
\usage{
computeObservationalWeights(model, x)
}
\arguments{
\item{model}{the zinb model}

\item{x}{the matrix of counts}
}
\value{
the matrix of observational weights computed from the model.
}
\description{
Given a matrix of counts, this function computes the
observational weights of the counts under a zero-inflated negative binomial
(ZINB) model. For each count, the ZINB distribution is parametrized by three
parameters: the mean value and the dispersion of the negative binomial
distribution, and the probability of the zero component.
}
\examples{
se <- SummarizedExperiment(matrix(rpois(60, lambda=1), nrow=10, ncol=6),
    colData = data.frame(bio = gl(2, 3)))
m <- zinbFit(se, X=model.matrix(~bio, data=colData(se)),
    BPPARAM=BiocParallel::SerialParam())
computeObservationalWeights(m, assay(se))
}
