% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinb.loglik}
\alias{zinb.loglik}
\title{Log-likelihood of the zero-inflated negative binomial model}
\usage{
zinb.loglik(Y, mu, theta, logitPi)
}
\arguments{
\item{Y}{the vector of counts}

\item{mu}{the vector of mean parameters of the negative binomial}

\item{theta}{the vector of dispersion parameters of the negative binomial, or
a single scalar is also possible if the dispersion parameter is constant.
Note that theta is sometimes called inverse dispersion parameter (and
phi=1/theta is then called the dispersion parameter). We follow the
convention that the variance of the NB variable with mean mu and dispersion
theta is mu + mu^2/theta.}

\item{logitPi}{the vector of logit of the probabilities of the zero component}
}
\value{
the log-likelihood of the model.
}
\description{
Given a vector of counts, this function computes the sum of the
log-probabilities of the counts under a zero-inflated negative binomial
(ZINB) model. For each count, the ZINB distribution is parametrized by three
parameters: the mean value and the dispersion of the negative binomial
distribution, and the probability of the zero component.
}
\examples{
n <- 10
mu <- seq(10,50,length.out=n)
logitPi <- rnorm(10)
zeta <- rnorm(10)
Y <- rnbinom(n=n, size=exp(zeta), mu=mu)
zinb.loglik(Y, mu, exp(zeta), logitPi)
zinb.loglik(Y, mu, 1, logitPi)
}
