% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{colMedians}
\alias{colMedians}
\alias{colMedians,Zi-method}
\alias{rowMedians}
\alias{rowMedians,Zi-method}
\title{Calculate the row or column median of zero-deinflated count data}
\usage{
\S4method{colMedians}{Zi}(x, rows = NULL, cols = NULL, na.rm = TRUE, ..., useNames = TRUE)

\S4method{rowMedians}{Zi}(x, rows = NULL, cols = NULL, na.rm = TRUE, ..., useNames = TRUE)
}
\arguments{
\item{x}{\code{\linkS4class{Zi}}-class object}

\item{rows, cols}{A  \code{\link[base]{vector}} indicating the subset of rows
(and/or columns) to operate over. If  \code{\link{NULL}}, no subsetting is
done}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}}
\code{\link{NA}}s are excluded, otherwise not. default = \code{\link{TRUE}}}

\item{...}{see \code{\link[MatrixGenerics]{colMedians}}}

\item{useNames}{\code{\link[base]{logical}}. If \code{\link{TRUE}} (default),
names attributes of result are set. Else if \code{\link{FALSE}}, no naming
support is done.}
}
\value{
returns a numeric vector of row/column length
}
\description{
Calculate the row or column median of  zero-deinflated data of a
\code{\linkS4class{Zi}}-class object. To calculate the median, the
deinflatedcounts matrix will be extracted.
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
colMedians(Zi, useNames = TRUE)
rowMedians(Zi, useNames = TRUE)
}
