datacache <- new.env(hash=TRUE, parent=emptyenv())

RmiR.hsa_dbconn <- function() dbconn(datacache)
RmiR.hsa_dbfile <- function() dbfile(datacache)

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "targets.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    packageStartupMessage("This package has not been updated by it's contributor since 2009.")
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(RmiR.hsa_dbconn())
}

