datacache <- new.env(hash=TRUE, parent=emptyenv())

hugene11stprobeset <- function() showQCData("hugene11stprobeset", datacache)
hugene11stprobeset_dbconn <- function() dbconn(datacache)
hugene11stprobeset_dbfile <- function() dbfile(datacache)
hugene11stprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hugene11stprobeset_dbInfo <- function() dbInfo(datacache)

hugene11stprobesetORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hugene11stprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hugene11stprobeset", "chip hugene11stprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hugene11stprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hugene11stprobeset_dbconn())
}

