datacache <- new.env(hash=TRUE, parent=emptyenv())

org.At.tair <- function() showQCData("org.At.tair", datacache)
org.At.tair_dbconn <- function() dbconn(datacache)
org.At.tair_dbfile <- function() dbfile(datacache)
org.At.tair_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.At.tair_dbInfo <- function() dbInfo(datacache)

org.At.tairORGANISM <- "Arabidopsis thaliana"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.At.tair.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ARABIDOPSIS_DB", "org.At.tair", "Arabidopsis", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.At.tair.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.At.tair_dbconn())
}

