\name{phastCons7way.UCSC.hg38-package}
\alias{phastCons7way.UCSC.hg38-package}
\alias{phastCons7way.UCSC.hg38}
\docType{package}

\title{
Annotation package for UCSC human phastCons scores from 7 vertebrate species
}
\description{
This annotation package stores phastCons conservation scores from UCSC for the
human genome (hg38), calculated from genome-wide multiple alignments with other
99 vertebrate species. The data are stored in the form of \code{\link[S4Vectors]{Rle}}
objects and are loaded automatically as an object of class
\code{\link[GenomicScores]{GScores}}. The name of the exposed object
matches the name of the package and part of the filename that contained the data
imported into the package. The class definition and methods to access
\code{\link[GenomicScores]{GScores}} objects are found in the
\code{\link[GenomicScores]{GenomicScores}} software package.
}

\format{
  \tabular{ll}{
    \code{\link{phastCons7way.UCSC.hg38}} \tab GScores object containing
    phastCons conservation scores
    from UCSC for the human genome (hg38)
    calculated from 7 vertebrate species
    and downloaded in March 2018 from
    \url{http://genome.ucsc.edu}. \cr
  }
}

\author{
R. Castelo
}

\seealso{
  \code{\link[GenomicScores]{GScores}}
  \code{\link[GenomicScores]{GenomicScores}}
}

\examples{
library(GenomicRanges)
library(phastCons7way.UCSC.hg38)

ls("package:phastCons7way.UCSC.hg38")

phast <- phastCons7way.UCSC.hg38
phast
citation(phast)
gscores(phast, GRanges("chr7:117592326-117592330"))
}

\source{
  Siepel A, Bejerano G, Pedersen JS, Hinrichs AS, Hou M, Rosenbloom K, Clawson H,
  Spieth J, Hillier LW, Richards S, et al. Evolutionarily conserved elements
  in vertebrate, insect, worm, and yeast genomes. Genome Res. 2005 Aug;15(8):1034-50.
  (http://www.genome.org/cgi/doi/10.1101/gr.3715005)

  UCSC Genome Browser
  (URL: \url{http://genome.ucsc.edu}) [March, 2018, accessed]
}

\keyword{package}
\keyword{data}
