% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timing.R
\name{plot_timing}
\alias{plot_timing}
\title{Plot timing of methods}
\usage{
plot_timing(res, method_colors = NULL, scaleMethod = NULL)
}
\arguments{
\item{res}{A data.frame with clustering results.}

\item{method_colors}{A named vector with colors to use for the different
clustering methods. Can be NULL, in which case colors are chosen
automatically.}

\item{scaleMethod}{Either NULL or one of the clustering methods in the result
data.frame. If not NULL, a plot will be generated where all elapsed times
are normalized by dividing with the time for \code{scaleMethod}. If NULL,
this plot will not be generated.}
}
\value{
A named list of ggplot2 objects
}
\description{
Plot the elapsed time for each clustering method
}
\examples{
res <- clustering_summary_filteredExpr10_Koh_v1()
plots <- plot_timing(res)

}
\author{
Angelo Duo, Charlotte Soneson
}
