% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HarmanData.R
\docType{data}
\name{IMR90}
\alias{IMR90}
\alias{imr90.data}
\alias{imr90.info}
\title{IMR90 data, a Human lung fibroblast cell line.}
\format{
Two data frames. \code{imr90.data} has 22,223 probesets (rows) and 12
samples (columns). While \code{imr90.info} is a description of the samples,
with two columns:
\describe{
  \item{\code{Treatment}}{the treatment applied to the cells}
  \item{\code{Batch}}{batch processing number}
}
}
\usage{
data(IMR90)
}
\value{
\code{\link{promise}}
}
\description{
Data used in the batch effect correction paper of Johnson, Li
and Rabinovich. The data are from a cell-line experimental designed to reveal
whether exposing mammalian cells to nitric oxide (NO) stabilizes mRNAs. The
data comprises one treatment, one control and 2 time points (0 h and 7.5 h),
resulting in 4 distinct (2 treatment x 2 time points) experimental
conditions. There were 3 batches and a total of 12 samples, with each batch
consisting of 1 replicate from each of the experimental conditions.
Affymetrix HG-U133A Arrays were normalised and background adjusted as a whole
using the RMA procedure in MATLAB.
}
\examples{
data(IMR90)
}
\references{
Johnson et al. Biostatistics (2007).
doi: 10.1093/biostatistics/kxj037
}
\keyword{Harman}
\keyword{data}
\keyword{datasets}
