% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{du_ttest_sim}
\alias{du_ttest_sim}
\alias{du_ttest_sim_fun}
\title{t-test simulation: Simulate rowwise t-tests}
\usage{
du_ttest_sim(
  m,
  pi0,
  effect_size,
  n_samples = 10,
  uninformative_filter = FALSE,
  seed = NULL
)

du_ttest_sim_fun(
  m,
  pi0,
  effect_size,
  n_samples = 10,
  uninformative_filter = FALSE
)
}
\arguments{
\item{m}{Integer, total number of hypotheses}

\item{pi0}{Numeric, proportion of null hypotheses}

\item{effect_size}{Numeric, the alternative hypotheses will be}

\item{n_samples}{Integer, number of samples for t-test, i.e.
the comparison will be n_samples/2 vs n_samples/2}

\item{uninformative_filter}{Boolean, if TRUE will generate uniformly distributed filter statistic
Otherwise will use the pooled standard deviations}

\item{seed}{Integer, Random seed to be used for simulation 
(default: NULL, i.e. RNG state will be used as is)}
}
\value{
A data frame containing all information about the simulation experiment
}
\description{
t-test simulation: Simulate rowwise t-tests
}
\section{Functions}{
\itemize{
\item \code{du_ttest_sim_fun}: Creates a closure function for a given seed
}}

\examples{
sim_df <- du_ttest_sim(20000,0.95, 1.5)

}
