## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----installation, eval=FALSE-------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("ExperimentHub")
# BiocManager::install("JohnsonKinaseData")

## ----load-anno----------------------------------------------------------------
library(JohnsonKinaseData)
anno <- getKinaseAnnotation()

head(anno)

## ----anno-spec----------------------------------------------------------------
xtabs(~AcceptorSpecificity, anno)

## ----anno-spec-sub------------------------------------------------------------
xtabs(~AcceptorSpecificity + KinaseSubType, anno)

## ----anno-spec-family---------------------------------------------------------
xtabs(~AcceptorSpecificity + KinaseFamily, anno)

## ----load-pwm-----------------------------------------------------------------
library(JohnsonKinaseData)
pwms <- getKinasePWM()

head(names(pwms))

## ----pwm-example--------------------------------------------------------------
pwms[["PLK2"]]

## ----pwm-st-------------------------------------------------------------------
getKinasePWM(includeSTfavorability=FALSE)[["PLK2"]]

## ----pwm-acc------------------------------------------------------------------
getKinasePWM(matchAcceptorSpecificity=TRUE)[["PLK2"]]

## ----peps-central-------------------------------------------------------------
ppeps <- c("SAGLLS*DEDC", "GDtND", "EKGDSN__", "HKRNyGsDER", "PEKS*GyNV")

sites <- processPhosphopeptides(ppeps)

sites

## ----peps-non-central---------------------------------------------------------
sites <- processPhosphopeptides(ppeps, onlyCentralAcceptor=FALSE)

sites

## ----score--------------------------------------------------------------------
selected <- sites |> 
  dplyr::pull(processed)

scores <- scorePhosphosites(pwms, selected)

dim(scores)

scores[,1:5]

## ----score-parallel-----------------------------------------------------------
scores <- scorePhosphosites(pwms, selected, BPPARAM=BiocParallel::SerialParam())

## ----score-percentile---------------------------------------------------------
scores <- scorePhosphosites(pwms, selected, scoreType="percentile")

scores[,1:5]

## ----background-tyr-----------------------------------------------------------
bg <- getBackgroundScores(phosphoAcceptor='Tyr')

## ----session-info-------------------------------------------------------------
sessionInfo()

