% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top_taxa.R
\name{get_top_taxa}
\alias{get_top_taxa}
\title{Obtain a data.frame of ordered taxa abundances at a given level}
\usage{
get_top_taxa(dat, taxon_level = "genus")
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{taxon_level}{Character string indicating the level of taxonomy to
aggregate the counts data. Must be the name of a column in
\code{MultiAssayExperiment::rowData(dat)}.}
}
\value{
A \code{data.frame}
}
\description{
This function takes a \code{MultiAssayExperiment} object and returns a
data.frame of the present taxa at a user-supplied taxonomy level,
and outputs the average abundances of the taxa.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
out <- get_top_taxa(in_dat, "genus")
out

}
