% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_MAE_SE.R
\name{parse_MAE_SE}
\alias{parse_MAE_SE}
\title{Parse a MultiExperimentAssay object and extract the elements as data.frames}
\usage{
parse_MAE_SE(dat, which_experiment = NULL, which_assay = NULL, type = "MAE")
}
\arguments{
\item{dat}{Either a \code{MultiAssayExperiment} or a
\code{SummarizedExperiment} object.}

\item{which_experiment}{Character string. If \code{type = "MAE"}, then
this is the name of the experiment to be accessed. If \code{NULL},
will default to the first available experiment.}

\item{which_assay}{Character string. Regardless of whether 
\code{type = "MAE"} or \code{"SE"}, this is the name of the selected
\code{SummarizedExperiment} object. If \code{NULL}, defaults to first listed.}

\item{type}{One of "MAE" denoting a \code{MultiAssayExperiment} or "SE"
denoting a \code{SummarizedExperiment}.}
}
\value{
Returns a list of 3 named data.frame elements, `counts`, `sam`, and
  `tax` denoting the counts data, sample metadata table, and taxonomy table,
  respectively.
}
\description{
This function takes an animalcules-formatted \code{MultiAssayExperiment}
object and parses it to extract a named assay alongside the taxonomy and
metadata.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
out <- parse_MAE_SE(in_dat)
head(out$tax)
head(out$sam)
head(out$counts)

out2 <- parse_MAE_SE(in_dat[["MicrobeGenetics"]],
                     which_assay = "MGX", type = "SE")

}
