% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_accessions.R
\name{download_accessions}
\alias{download_accessions}
\title{Download indexes required for MetaScope ID and MetaBlast modules}
\usage{
download_accessions(
  ind_dir,
  tmp_dir = file.path(ind_dir, "tmp"),
  remove_tmp_dir = TRUE,
  NCBI_accessions_database = TRUE,
  NCBI_accessions_name = "accessionTaxa",
  silva_taxonomy_database = TRUE,
  silva_taxonomy_name = "all_silva_headers",
  blast_16S_database = TRUE,
  blast_16S_name = "16S_ribosomal_RNA"
)
}
\arguments{
\item{ind_dir}{Character string. Directory filepath where indices should be
saved. Required.}

\item{tmp_dir}{Character path to directory for storing temp files. (Useful
to avoid redownloading) Defaults to \code{file.path(ind_dir, "tmp")}}

\item{remove_tmp_dir}{Delete tmp_dir after downloads are complete? Defaults
to \code{TRUE}}

\item{NCBI_accessions_database}{Logical. Download taxonomizr NCBI accessions
database? Defaults to \code{TRUE}.}

\item{NCBI_accessions_name}{Character string. Filename (with or without
extension) to save taxonomizr NCBI accessions database. Defaults to
\code{"accessionTaxa.sql"}.}

\item{silva_taxonomy_database}{Logical. Download SILVA taxonomy database?
Defaults to \code{TRUE}.}

\item{silva_taxonomy_name}{Character string. Filename (with or without
extension) to save SILVA taxonomy database.
Defaults to the file supplied with the package,
\code{"all_silva_headers.rds"}.}

\item{blast_16S_database}{Logical. Download BLAST 16S database?
Defaults to \code{TRUE}.}

\item{blast_16S_name}{Character string. Filename (without extension) to save \
BLAST 16S database.
Defaults to the file supplied with the package,
\code{"16S_ribosomal_RNA"}.}
}
\value{
Exports database(s) with names and to location specified by the user.
}
\description{
This is a necessary step for all samples utilizing NCBI and SILVA databases
in the MetaScope pipeline. As specified by the user,
\code{download_accessions} will automatically download the NCBI accessions
database, the SILVA taxonomy database, and or the NCBI Blast 16S database and
prepare consolidated databases for downstream use with the MetaID and
MetaBLAST modules. This package relies on the \code{taxonomizr} package.
}
\examples{
\dontrun{
  download_accessions(
    ind_dir = "C:/Users/JohnSmith/Research",
    tmp_dir = file.path(ind_dir, "tmp"),
    remove_tmp_dir = TRUE,
    NCBI_accessions_database = TRUE,
    NCBI_accessions_name = "accessionTaxa.sql",
    silva_taxonomy_database = TRUE,
    silva_taxonomy_name = "all_silva_headers.rds")
}

}
