% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_inspect.R
\name{metascope_inspect}
\alias{metascope_inspect}
\title{Inspect a Bowtie index}
\usage{
metascope_inspect(bt2_base, ...)
}
\arguments{
\item{bt2_base}{The path to the Bowtie2 index files minus minus trailing
.1.bt2/.2.bt2 extension names.}

\item{...}{Required additional arguments to be passed on to the \code{bowtie2-inspect}
binaries. See below for details.}
}
\description{
This function can be use to call the \code{bowtie2-inspect} wrapper which
wraps the \code{bowtie2-inspect-s} and \code{bowtie2-inspect-l} binaries.
}
\details{
All additional arguments in ... are intepreted as
parameters to be passed on to \code{bowtie2-inspect} wrapper. All of them
\code{Character} or \code{Numeric} scalar. You can put all additional
arguments in one \code{Character} (e.g. "--across 60 --names") with white
space separation, or put them in different \code{Character}
(e.g. "--across","60","--names"). See the output of
\code{metascope_inspect_usage()} for details about available parameters.
}
\examples{
\dontrun{
metascope_inspect(bt2_base)
}
}
\references{
{
Langmead B, Wilks C, Antonescu V, Charles R. Scaling
read aligners to hundreds of threads on general-purpose processors.
Bioinformatics. 2018 Jul 18. doi: 10.1093/bioinformatics/bty648.

Langmead B, Salzberg SL. Fast gapped-read alignment with
Bowtie 2. Nature Methods. 2012 Mar 4;9(4):357-9. doi: 10.1038/nmeth.1923.
}
}
