% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose_GPGx8cTerm}
\alias{compose_GPGx8cTerm}
\title{Compose a peptide with a defined AA sequence frequency}
\usage{
compose_GPGx8cTerm(pool = c(rep("A", 12), rep("S", 0), rep("T", 12),
  rep("N", 12), rep("Q", 12), rep("D", 8), rep("E", 0), rep("V", 12),
  rep("L", 0), rep("F", 0), rep("Y", 8), rep("W", 0), rep("G", 12),
  rep("P", 12)), cTerm = c("VFR", "VSR", "VFGIR", "VSGER"))
}
\arguments{
\item{pool}{AA distributen.}

\item{cTerm}{c-Terms}
}
\value{
a AA sequence
}
\description{
composes, out of an as input given amino acid distribution,
a randomly sampled amino acid sequence. \code{\link{compose_GPGx8cTerm}},
\code{\link{compose_GSx7cTerm}}, and \code{\link{compose_GPx10R}} belong to
three groups composing different flycode (peptide) construction.
The construction is given in the function name. For example, GPGx8cTerm,
composes a flycode having as prefix GPG followed by eight (x8) amino acids
followed by a cTerm sequence. The different construction will have different
detectability properties as mass range and hydrophobicity values.
}
\examples{
set.seed(1)
compose_GPGx8cTerm()
(FlyCodes <- replicate(10, compose_GPGx8cTerm()))
plot(parentIonMass(FlyCodes) ~ssrc(FlyCodes))
}
\author{
Christian Panse <cp@fgcz.ethz.ch> 2015
}
