/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;

public class ZeroLengthPathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private QueryBindingSet result;
    private Var subjectVar;
    private Var objVar;
    private Value subj;
    private Value obj;
    private BindingSet bindings;
    private CloseableIteration<BindingSet, QueryEvaluationException> subjectIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> objectIter;
    private Set<Value> reportedValues;
    private Var contextVar;
    private final EvaluationStrategyImpl evaluationStrategyImpl;

    public ZeroLengthPathIteration(EvaluationStrategyImpl evaluationStrategyImpl, Var subjectVar, Var objVar, Value subj, Value obj, Var contextVar, BindingSet bindings) {
        this.evaluationStrategyImpl = evaluationStrategyImpl;
        this.result = new QueryBindingSet(bindings);
        this.subjectVar = subjectVar;
        this.objVar = objVar;
        this.contextVar = contextVar;
        this.subj = subj;
        this.obj = obj;
        this.bindings = bindings;
        if (subj != null && obj == null) {
            this.result.addBinding(objVar.getName(), subj);
        }
        if (obj != null && subj == null) {
            this.result.addBinding(subjectVar.getName(), obj);
        }
        this.reportedValues = this.makeSet();
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.subj == null && this.obj == null) {
            Value v;
            QueryBindingSet next;
            if (this.subjectIter == null) {
                this.subjectIter = this.createSubjectIteration();
            }
            while (this.subjectIter.hasNext()) {
                next = new QueryBindingSet((BindingSet)this.subjectIter.next());
                v = next.getValue(this.subjectVar.getName());
                if (!this.add(this.reportedValues, v)) continue;
                next.addBinding(this.objVar.getName(), v);
                return next;
            }
            if (this.objectIter == null) {
                this.objectIter = this.createObjectIteration();
            }
            while (this.objectIter.hasNext()) {
                next = new QueryBindingSet((BindingSet)this.objectIter.next());
                v = next.getValue(this.objVar.getName());
                if (!this.add(this.reportedValues, v)) continue;
                next.addBinding(this.subjectVar.getName(), v);
                return next;
            }
        } else {
            QueryBindingSet next = this.result;
            this.result = null;
            return next;
        }
        this.reportedValues = null;
        return null;
    }

    protected boolean add(Set<Value> reportedValues2, Value v) throws QueryEvaluationException {
        return reportedValues2.add(v);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> createSubjectIteration() throws QueryEvaluationException {
        Var predicate = this.createAnonVar("zero-length-internal-pred");
        Var endVar = this.createAnonVar("zero-length-internal-end");
        StatementPattern subjects = new StatementPattern(this.subjectVar, predicate, endVar);
        if (this.contextVar != null) {
            subjects.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
            subjects.setContextVar(this.contextVar);
        }
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluationStrategyImpl.evaluate(subjects, this.bindings);
        return iter;
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> createObjectIteration() throws QueryEvaluationException {
        Var startVar = this.createAnonVar("zero-length-internal-start");
        Var predicate = this.createAnonVar("zero-length-internal-pred");
        StatementPattern subjects = new StatementPattern(startVar, predicate, this.objVar);
        if (this.contextVar != null) {
            subjects.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
            subjects.setContextVar(this.contextVar);
        }
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluationStrategyImpl.evaluate(subjects, this.bindings);
        return iter;
    }

    private Set<Value> makeSet() {
        return new HashSet<Value>();
    }

    public Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }
}

