/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.utils;

import slib.sml.sm.core.utils.SMConstants;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;

public abstract class ICconf
extends Conf {
    private final String id;
    private final String label;
    private final String flag;
    private String className;
    private boolean isCorpusBased;

    public ICconf(String icFlag) throws SLIB_Ex_Critic {
        this.id = icFlag;
        this.label = icFlag;
        this.flag = icFlag;
        this.validate();
    }

    public ICconf(String id, String label, String flag) throws SLIB_Ex_Critic {
        this.id = id;
        this.label = label;
        this.flag = flag;
        this.validate();
    }

    private void validate() throws SLIB_Ex_Critic {
        if (SMConstants.SIM_PAIRWISE_DAG_NODE_IC_ANNOT.containsKey(this.flag)) {
            this.className = SMConstants.SIM_PAIRWISE_DAG_NODE_IC_ANNOT.get(this.flag);
            this.isCorpusBased = true;
        } else if (SMConstants.SIM_PAIRWISE_DAG_NODE_IC_INTRINSIC.containsKey(this.flag)) {
            this.className = SMConstants.SIM_PAIRWISE_DAG_NODE_IC_INTRINSIC.get(this.flag);
            this.isCorpusBased = false;
        } else {
            throw new SLIB_Ex_Critic("Unknown IC Flag " + this.flag);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFlag() {
        return this.flag;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isCorpusBased() {
        return this.isCorpusBased;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICconf other = (ICconf)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public String toString() {
        String out = "id : " + this.id + "\n";
        out = out + "label : " + this.label + "\n";
        out = out + "corpusBased : " + this.isCorpusBased + "\n";
        out = out + "flag : " + this.flag + "\n";
        out = out + super.toString();
        return out;
    }
}

