#' 
#' Mutations datasets from TCGA project
#'
#' Package provides mutations datasets from The Cancer Genome Atlas Project for all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for the date: \code{2015-11-01}. The process is described here: \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data} family can be found here: \code{browseVignettes("RTCGA")}
#' Mutations data format is explained here https://wiki.nci.nih.gov/display/TCGA/Mutation+Annotation+Format+(MAF)+Specification. There is extra one column with patients' barcodes.
#' 
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @return Data frames with mutations data.
#' 
#' @import RTCGA
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' @name mutations
#' @rdname mutations
#' @aliases ACC.mutations,BLCA.mutations,BRCA.mutations,CESC.mutations,CHOL.mutations,COAD.mutations,COADREAD.mutations,DLBC.mutations,ESCA.mutations,GBMLGG.mutations,GBM.mutations,HNSC.mutations,KICH.mutations,KIPAN.mutations,KIRC.mutations,KIRP.mutations,LAML.mutations,LGG.mutations,LIHC.mutations,LUAD.mutations,LUSC.mutations,OV.mutations,PAAD.mutations,PCPG.mutations,PRAD.mutations,READ.mutations,SARC.mutations,SKCM.mutations,STAD.mutations,STES.mutations,TGCT.mutations,THCA.mutations,UCEC.mutations,UCS.mutations,UVM.mutations
#'
"ACC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'
"BLCA.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"BRCA.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"CESC.mutations"    
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"CHOL.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"COAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"COADREAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'
"DLBC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'
"ESCA.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'
"GBMLGG.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"GBM.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"HNSC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"KICH.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"KIPAN.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"KIRC.mutations"    
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"KIRP.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"LAML.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"LGG.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"LIHC.mutations"    
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"LUAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"LUSC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"OV.mutations"      
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"PAAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"PCPG.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'
"PRAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#'  
"READ.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"SARC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"SKCM.mutations"    
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"STAD.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"STES.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"TGCT.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"THCA.mutations"    
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"UCEC.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"UCS.mutations"
#' @name mutations
#' @rdname mutations
#' @format NULL
#' 
"UVM.mutations"