#' 
#' @title rnaseq datasets from TCGA project
#'
#' @description rnaseq data 
#' format is explained here \url{https://wiki.nci.nih.gov/display/TCGA/RNASeq+Version+2}. Package provides rnaseq datasets from The Cancer Genome Atlas Project for all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for the date: \code{2015-11-01}. The process is described here: \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA} family can be found here: \code{browseVignettes("RTCGA")}. Data source is illumina hiseq Level 3 RSEM normalized expression data.
#' Converting \pkg{RTCGA.rnaseq} to Bioconductor datasets' format is explained here \link{convertTCGA}.
#' 
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @return Data frames with rnaseq data.
#' 
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' 
#' @import RTCGA
#' @name rnaseq
#' @rdname rnaseq
#' @aliases ACC.rnaseq,BLCA.rnaseq,BRCA.rnaseq,CESC.rnaseq,CHOL.rnaseq,COAD.rnaseq,COADREAD.rnaseq,DLBC.rnaseq,ESCA.rnaseq,GBMLGG.rnaseq, GBM.rnaseq,HNSC.rnaseq,KICH.rnaseq,KIPAN.rnaseq,KIRC.rnaseq,KIRP.rnaseq,LAML.rnaseq,LGG.rnaseq,LIHC.rnaseq,LUAD.rnaseq,LUSC.rnaseq,OV.rnaseq,PAAD.rnaseq,PCPG.rnaseq,PRAD.rnaseq,READ.rnaseq,SARC.rnaseq,SKCM.rnaseq,STAD.rnaseq,STES.rnaseq,TGCT.rnaseq,THCA.rnaseq,THYM.rnaseq,UCEC.rnaseq,UCS.rnaseq,UVM.rnaseq
#'
"ACC.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#'
"BLCA.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"BRCA.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"CESC.rnaseq"    
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"CHOL.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"COAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"COADREAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"DLBC.rnaseq"    
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"ESCA.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"GBMLGG.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"GBM.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"HNSC.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"KICH.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"KIPAN.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"KIRC.rnaseq"    
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"KIRP.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"LAML.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"LGG.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"LIHC.rnaseq"    
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"LUAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"LUSC.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"OV.rnaseq"      
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"PAAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"PCPG.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"PRAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"READ.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"SARC.rnaseq"  
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"SKCM.rnaseq"  
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"STAD.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
"STES.rnaseq"   
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"TGCT.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"THCA.rnaseq"    
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"THYM.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"UCEC.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"UCS.rnaseq"
#' @name rnaseq
#' @rdname rnaseq
#' @format NULL
#' 
"UVM.rnaseq"