% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstut.R
\name{new_ions}
\alias{new_ions}
\alias{mstut}
\alias{analyse}
\alias{analyze}
\alias{detect}
\alias{spectrum}
\title{Create, analyse and detect ions}
\usage{
new_ions(npeaks = 10, mzrange = c(100, 1000), nimg = 100)

analyse(x, sleep = 0.1)

analyze(x, sleep = 0.1)

detect(x, new = FALSE)

spectrum(x, ...)
}
\arguments{
\item{npeaks}{A `numeric` scalar defining the number of unique
peaks (M/Z values). Default is 10.}

\item{mzrange}{A `numeric` of length 2 defining the range of
possible M/Z values. Default is `c(100, 1000)`.}

\item{nimg}{A `numeric` scalar. When analysing the ions, their
separation along their M/Z values will be split along a
sequence of length `nimg`. Default is 100.}

\item{x}{An object of class `ions`.}

\item{sleep}{How much time to wait before producing the next plot.}

\item{new}{A `logical` scalar, indicating if the separated ions
(last frame of calling `analyse) should be plotting, or
whether the detection should be overlaid. Default is `FALSE`,
to add the plot on top of the opened device.}

\item{...}{Additional arguments passed to [graphics::plot()].}
}
\value{
An object of class `ions`.

`analyse`, `detect` and `spectrum` are used for their side
    effect or producing plots. They all invisibly return `NULL`.
}
\description{
This is the constructor function to generate a set of ions that
can later be analysed with `analyse()` and detected with
`detect()`.
}
\examples{
set.seed(1L)
x <- new_ions(nimg = 5)
x
analyse(x)
detect(x)
spectrum(x)
}
\author{
Laurent Gatto
}
