% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubcellularSpatialData.R
\docType{package}
\name{SubcellularSpatialData-package}
\alias{SubcellularSpatialData}
\alias{SubcellularSpatialData-package}
\title{SubcellularSpatialData: Annotated spatial transcriptomics datasets from 10x Xenium, NanoString CosMx and BGI STOmics.}
\description{
This is a data package that hosts annotated sub-cellular localised datasets from the STOmics, Xenium and CosMx platforms. Specifically, it hosts datasets analysed in the publication Bhuva et. al, 2024 titled "Library size confounds biology in spatial transcriptomics data". Raw transcript detections are hosted and functions to convert them to SpatialExperiment objects have been implemented.
}
\details{
The data in this package is published in the publication Bhuva et al., \emph{Genome Biology}, 2024. Annotations for each dataset are obtained independently of the molecular measurements. The lowest level of measurement is annotated for each dataset. For BGI STOmics, this is each DNA nanoball, and for 10x Xenium and NanoString CosMx, these are the individual transcript detections.

The package provides the \code{\link{tx2spe}} function to convert these unit measurements into higher level summaries such as cells, regions, square bins, or hex bins for analysis purposes. These summaries are stored in SpatialExperiment objects.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://davislaboratory.github.io/SubcellularSpatialData}
  \item Report bugs at \url{https://github.com/DavisLaboratory/SubcellularSpatialData/issues}
}

}
\author{
\strong{Maintainer}: Dharmesh D. Bhuva \email{dharmesh.bhuva@adelaide.edu.au} (\href{https://orcid.org/0000-0002-6398-9157}{ORCID})

}
\keyword{internal}
