\name{toy.data}
\docType{data}
\alias{toy.data}
\title{Simulated Toy example of Gene Expression Data}
\description{
    Dataset containing 64 samples and 64 genes generated by the publicly 
    available GNW generator using an ecoli source network. 
}
\usage{data(toy.data)}
\format{
    \code{toy.data} is a data frame containing 64 rows and 64 columns. 
    Each row contains a simulated microarray experiment and each column 
    contains a gene.
}
\source{
    GNW v3.1  with source network :  Example (Ecoli)
}
\references{
    Schaffter, Thomas, Daniel Marbach, and Dario Floreano. "GeneNetWeaver: 
    in silico benchmark generation and performance profiling of network 
    inference methods." Bioinformatics 27.16 (2011): 2263-2270.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{toy.net}}
}
\examples{
    data(toy.data)
    # Print size
    print(dim(toy.data))
}
\keyword{datasets}
