## ----install, eval=FALSE------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("muSpaData")
# 
# ## Check that you have a valid Bioconductor installation
# BiocManager::valid()

## ----message = FALSE----------------------------------------------------------
suppressMessages({
    library(muSpaData)
    library(ExperimentHub)
    library(ggplot2)
})

## ----message = FALSE----------------------------------------------------------
# Load the small example spe data
(spe <- Wei22_example())

## ----eval=FALSE---------------------------------------------------------------
# # If you want to download the full data (about 5.2 GB in RAM) use:
# if (benchmarkme::get_ram() > 5e9) {
#     Wei22_full()
# }

## ----message = FALSE----------------------------------------------------------
# Connect to ExperimentHub and create Hub instance
eh <- ExperimentHub()
(q <- query(eh, "muSpaData"))
# load the first resource in the list
q[[1]]  
# load by accession id
eh[["EH9613"]]

## ----message = FALSE----------------------------------------------------------
listResources(eh, "muSpaData")

# load data using a character vector of metadata search terms 
loadResources(eh, "muSpaData", c("example"))

## ----view ARTISTA Banksy, fig.width=5,fig.height=4----------------------------
# View LIBD layers for one sample
CD <- colData(spe) |> as.data.frame()
ggplot(CD, 
    aes(x=sdimx,y=sdimy, 
    color=factor(Banksy_smooth))) +
    geom_point(size = 0.25) + 
    theme_void() + 
    theme(legend.position="bottom") + 
    facet_wrap(~ sample_id, scales = 'free') +
    labs(color = "", title = paste0("Banksy spatial clusters"))

## -----------------------------------------------------------------------------
sessionInfo()

