## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(eval=TRUE, message = FALSE, warning = FALSE)

## ----show-metadata------------------------------------------------------------
# checking metadata
meta_path <- system.file("extdata", "metadata.csv", package = "nmrdata")
if (file.exists(meta_path)) {
  meta <- utils::read.csv(meta_path)
  head(meta[c("Title","RDataPath")])
}

## ----install-lib, eval=FALSE--------------------------------------------------
# # Install from Bioconductor
# # if (!require("BiocManager")) install.packages("BiocManager")
# # BiocManager::install("nmrdata")

## ----ep-setup, eval=TRUE------------------------------------------------------
library(ExperimentHub)

eh <- ExperimentHub()
query(eh, "nmrdata")

## ----load-processed, eval=TRUE------------------------------------------------
hub_id = 'EH9905' # Bariatric pre-processed        

bariatric <- eh[[hub_id]]
str(bariatric, max.level = 1)

# visualise the first NMR spectrum
plot(bariatric$ppm, bariatric$X.pqn[1, ], type = "l",
     xlab = "Chemical shift (ppm)", ylab = "Intensity")

# an: sample annotation data (row-matched to `X.pqn`)
head(bariatric$an)
stopifnot(nrow(bariatric$an)==nrow(bariatric$X.pqn))

# meta: TopSpin acquisition and processing parameters (row-matched to `X.pqn`)
head(colnames(bariatric$meta), 10)
stopifnot(nrow(bariatric$meta)==nrow(bariatric$X.pqn))

# Ex Parameters:
meta = bariatric$meta

meta$a_SFO1[1] # carrier frequency
meta$a_NS[1] # number of scans
meta$a_OVERFLW[1] # overflow

meta$p_SI[1] # nb of points in spectrum (zero filled)
meta$p_LB[1] # line broadening factor

## ----raw-dir, eval=TRUE-------------------------------------------------------
library(nmrdata)

# download once, unpack once; returns the directory path
exp_dir <- getRawExpDir(quiet = TRUE)

# show experiment folder content
list.files(exp_dir, recursive = TRUE)[1:10]

## ----metabom8, eval=FALSE-----------------------------------------------------
# library(metabom8)
# 
# # import Bruker 1D NMR spectra
# res <- read1d_proc(exp_dir, exp_type = list(pulprog = "noesypr1d"))
# 
# # plot first spectrum
# spec(res$X[1, ], res$ppm)

## ----cache-info, eval=TRUE----------------------------------------------------
# where the archive and unpacked folder live
dir <- getRawExpDir(quiet = TRUE)
print(dir)

## -----------------------------------------------------------------------------
packageVersion("nmrdata")

## -----------------------------------------------------------------------------
sessionInfo()

