% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadOrthosData.R
\name{GetorthosContrastDB}
\alias{GetorthosContrastDB}
\title{Cache an orthosData contrast DB}
\usage{
GetorthosContrastDB(
  organism = c("Human", "Mouse"),
  mode = c("ANALYSIS", "DEMO"),
  ARCHS4v = "v212",
  verbose = TRUE
)
}
\arguments{
\item{organism}{Character scalar selecting the organism for which to load the
contrast database. One of \code{"Human"} or \code{"Mouse"}.}

\item{mode}{When in "ANALYSIS" mode (default) the complete contrast DB is
cached. "DEMO" mode caches a small "toy" database for the queries.
"DEMO" should only be used for testing/demonstration purposes
and never for actual analysis purposes.}

\item{ARCHS4v}{Version of ARCHS4 used to build the contrastDB.}

\item{verbose}{Logical scalar indicating whether to print messages along
the way.}
}
\value{
the \code{dirname} of the cached objects.
}
\description{
Download in cache HDF5 and RDS component files for an othosData contrast
database from ExperimentHub.
As these are components of a single HDF5SummarizedExperiment object they
HAVE to be cached with the exact prefix used at creation time (see
\code{\link[HDF5Array:saveHDF5SummarizedExperiment]{HDF5Array::saveHDF5SummarizedExperiment}}
)
}
\details{
The orthosData  contrast database contains over 100,000
differential gene expression experiments
compiled from the ARCHS4 database* of publicly available expression data.
Each entry in the database corresponds to a pair of RNAseq samples contrasting
a treatment vs a control condition.

A combination of metadata-semantic and quantitative analyses was used to
determine the proper assignment of samples to such pairs in `orthosData`.

The ~20,000 gene features/organism used in the database are "sanctioned"
according to several criteria (located on canonical chromosomes, no
pseudogenes, no ribosomal protein genes, detected in at least a small
fraction of the ARCHS4 database).

The orthosData  contrast database contains assays with the original
contrasts in the form of gene expression log2 CPM ratios (i.e log2 fold
changes, log2FCs), precalculated, decoded and residual components of those
contrasts using the orthosData models as well as the gene expression context
of those contrasts in the form of log2-transformed library normalized counts
(i.e log2 counts per million, log2CPMs).
It also contains extensive annotation on both the `orthos` feature genes
and the contrasted conditions.

For each organism the DB is stored as an HDF5SummarizedExperiment with an
HDF5 component that contains the gene assays and an rds component that
contains gene annotation in the rowData and the contrast annotation in the
colData.

Note that because of the way that HDF5 datasets and serialized
SummarizedExperiments are linked in an HDF5SummarizedExperiment, the two
components -although relocatable- need to have the exact same filenames
as those used at creation time. In other words the files can be moved (or
copied) to a different directory or to a different machine and they will
retain functionality as long as both live in the same directory and are
never renamed.

All orthosData datasets are publicly available through
\href{https://doi.org/10.5281/zenodo.7554914}{zenodo.org}
according to open data standards and licenses under the 
\href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International license (CC-BY 4.0)}.
}
\examples{
GetorthosContrastDB(organism = "Mouse", mode="DEMO")

se <- HDF5Array::loadHDF5SummarizedExperiment(dir = ExperimentHub::getExperimentHubOption("CACHE"),
prefix = "mouse_v212_NDF_c100_DEMO")

}
\references{
{
*Lachmann, Alexander, et al.
"Massive mining of publicly available RNA-seq data from human and mouse."
 Nature communications 9.1 (2018): 1366
}
}
\seealso{
\code{\link[HDF5Array:saveHDF5SummarizedExperiment]{HDF5Array::saveHDF5SummarizedExperiment}}

\href{https://doi.org/10.5281/zenodo.7554914}{https://doi.org/10.5281/zenodo.7554914}
}
\author{
Panagiotis Papasaikas
}
