\name{E14TG2a}
\alias{E14TG2a}
\alias{E14TG2aS1}
\alias{E14TG2aS2}
\alias{E14TG2aR}
\alias{E14TG2aS1yLoc}
\alias{E14TG2aS1goCC}

\docType{data}

\title{
  LOPIT experiment on Mouse E14TG2a Embryonic Stem Cells from Breckels
  et al. (2016)
}

\description{
  This is data from a standard LOPIT experimental design on Mouse E14TG2a embryonic stem cells. See below for more details. 
}

\usage{
data(E14TG2aS1)
data(E14TG2aS2)
data(E14TG2aR)
data(E14TG2aS1yLoc)
data(E14TG2aS1goCC)
}

\format{
  The data is an instance of class \code{MSnSet} from package \code{MSnbase}.
}

\details{
  This is a LOPIT experiment. Normalised intensities of proteins from eight
  iTRAQ 8-plex labelled fractions are available for 2 replicates (indexed 1 
  and 2) using stringent and relaxed setting (S and R, respectively). 
  
  The \code{E14TG2aS1goCC} instance contains binary assay data. Its
  columns represent GO CC terms that have been observed for the object's
  features. A 1 indicates that a GO term has been associated to a given
  feature (protein); a 0 means not such association was found in the GO
  ontology.
  
  The \code{E14TG2aS1yLoc} instance contains 34 sequence and annotation
  features obtained from a feature selection of the sequence and annotation
  features from the computational classifier YLoc. These features include: 
  variants of psuedo amino acid counts, autocorrelation, sum of charge, prosite
  patterns, Gene Ontoloy terms and the number of signal peptides. These features are
  described in detail in Breckels et al (2015).
}

\source{
  The data was generated by A. Christoforou at the Cambridge Centre for 
  Proteomics, Cambridge.
  \url{http://www.bio.cam.ac.uk/proteomics/}. 
  

}


\examples{
data(E14TG2aS1)
E14TG2aS1
pData(E14TG2aS1)
head(exprs(E14TG2aS1))
}

\keyword{datasets}
