% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveATAC.R
\name{saveATAC}
\alias{saveATAC}
\title{A function to save a scATAC-seq dataset stored in a SingleCellExperiment}
\usage{
saveATAC(object, outdir, format = "mtx")
}
\arguments{
\item{object}{The SingleCellExperiment object to be written to disk, this should be an individual dataset returned by queryATAC.}

\item{outdir}{The directory to save the data in, the directory should not exist yet.}

\item{format}{The format to save the data in, the default is Matrix Market File Format. Alternative format is h5ad.}
}
\value{
Nothing
}
\description{
This function allows you to save the counts,
peaks, cell ID's/barcodes, and any cell clustering data to disk in csv format. It takes two options:
an object to save and a directory to save in. Multiple files will be created in
the provided output directory, one for each type of data available in the scATAC_data object
(counts, cell ID/Barcode, peak regions, cell type/cluster annotations).
}
\examples{

# Retrieve a previously identified dataset (see queryATAC) and save it to disk
res <- queryATAC(accession = 'GSE89362')[[1]]
\dontshow{
         #res <- SingleCellExperiment(list(counts=matrix()))
         tdir = tempdir()
         output_directory_name = file.path(tdir, 'save_tme_data')}
saveATAC(res, output_directory_name)

}
\keyword{scATAC-seq}
