% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DarmanisBrainData.R
\name{DarmanisBrainData}
\alias{DarmanisBrainData}
\title{Obtain the Darmanis brain data}
\usage{
DarmanisBrainData(
  ensembl = FALSE,
  location = TRUE,
  remove.htseq = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{remove.htseq}{Logical scalar indicating whether HT-seq alignment statistics should be removed.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the human brain single-cell RNA-seq dataset from Darmanis et al. (2015).
}
\details{
Column metadata is scraped from GEO and includes patient information, tissue of origin and likely cell type. 

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
This is only performed when \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/darmanis-brain}.
}
\examples{
sce <- DarmanisBrainData()

}
\references{
Darmanis S et al. (2015). 
A survey of human brain transcriptome diversity at the single cell level. 
\emph{Proc Natl Acad Sci USA} 112, 7285-90.
}
\author{
Aaron Lun
}
