% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petrosius2023_mES.R
\docType{data}
\name{petrosius2023_mES}
\alias{petrosius2023_mES}
\title{Petrosius et al, 2023 (Nat. Comm.): Mouse embryonic stem cell (mESC) in
different culture conditions}
\format{
A \link{QFeatures} object with 605 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item Assay 1-603: PSM data acquired with an orbitrap-based data-independent
acquisition (DIA) protocol, hence those assays contain single column
that contains the quantitative information.
\item \code{peptides}: peptide data containing quantitative data for 9884
peptides and 603 single-cells.
\item \code{proteins}: protein data containing quantitative data for 4270
proteins and 603 single-cells.
}

Sample annotation is stored in \code{colData(petrosius2023_mES())}.
}
\source{
The peptide and protein data can be downloaded from the
\href{https://dataverse.uclouvain.be/dataset.xhtml?persistentId=doi:10.14428/DVN/EMAVLT}{Dataverse}
The raw data and the quantification data can also be found in
the MassIVE repository \code{MSV000092429}:
ftp://MSV000092429@massive.ucsd.edu/.
}
\usage{
petrosius2023_mES
}
\description{
Profiling mouse embryonic stem cells across ground-state (m2i) and
differentiation-permissive (m15) culture conditions. The data were
acquired using orbitrap-based data-independent acquisition (DIA).
The objective was to demonstrate the capability of their approach
by profiling mouse embryonic stem cell culture conditions, showcasing
heterogeneity in global proteomes, and highlighting differences in
the expression of key metabolic enzymes in distinct cell subclusters.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Sample isolation}: Cell sorting was done on a Sony MA900 cell sorter
using a 130 microm sorting chip. Cells were sorted at single-cell resolution,
into a 384-well Eppendorf LoBind PCR plate (Eppendorf AG) containing 1 microL
of lysis buffer.
\item \strong{Sample preparation}: Single-cell protein lysates were digested with
2 ng of Trypsin supplied in 1 microL of digestion buffer which was
carried out overnight at 37 °C, and subsequently acidified by the
addition of 1 microL 1\% (v/v) trifluoroacetic acid (TFA). All liquid
dispensing was done using an I-DOT One instrument.
\item \strong{Liquid chromatography}: For the HRMS1-DIA experiments and the DIA
isolation window survey, Evosep One liquid chromatography was used.
The standard 31-minute or 58-minute pre-defined Whisper gradients were
used with a flow rate of 100 nl/min for peptide elution.
\item \strong{Mass spectrometry}: The mass spectrometer was operated in positive
mode with the FAIMSPro interface compensation voltage set to -45 V.
MS1 scans were carried out at 120,000 resolution with an automatic gain
control (AGC) of 300\% and maximum injection time set to auto. For the DIA
isolation window survey, a scan range of 500–900 was used, and 400–1000
rest of the experiments. Higher energy collisional dissociation (HCD) was
used for precursor fragmentation with a normalized collision energy (NCE)
of 33\% and the MS2 scan AGC target was set to 1000\%.
\item \strong{Raw data processing}: The mESC raw data files were processed with
Spectronaut 17.
}
}

\section{Data collection}{


The data were provided by the Author and is accessible at the
\href{https://dataverse.uclouvain.be/dataset.xhtml?persistentId=doi:10.14428/DVN/EMAVLT}{Dataverse}
The folder ('20240205_111248_mESC_SNEcombine_m15-m2i/') contains
the following files of interest:
\itemize{
\item \verb{20240205_111251_PEPQuant (Normal).tsv}: the PSM level data
\item \verb{20240205_111251_Peptide Quant (Normal).tsv}: the peptide level data
\item \verb{20240205_111251_PGQuant (Normal).tsv}: the protein level data
}

The metadata were downloaded from the \href{https://zenodo.org/records/8146605}{Zenodo repository}.
\itemize{
\item \code{sample_facs.csv}: the metadata
}

We formatted the quantification table so that columns match with the
metadata. Then, both tables are then combined in a single
\link{QFeatures} object using the \code{\link[scp:readSCP]{scp::readSCP()}} function.

The peptide data were formated to a \link{SingleCellExperiment} object and the
sample metadata were matched to the column names and stored in the \code{colData}.
The object is then added to the \link{QFeatures} object and the rows of the PSM
data are linked to the rows of the peptide data based on the peptide sequence
information through an \code{AssayLink} object.

The protein data were formated to a \link{SingleCellExperiment} object and
the sample metadata were matched to the column names and stored in the
\code{colData}. The object is then added to the \link{QFeatures} object and the rows
of the peptide data are linked to the rows of the protein data based on the
protein sequence information through an \code{AssayLink} object.
}

\examples{
\donttest{
petrosius2023_mES()
}

}
\references{
\strong{Source article}: Petrosius, V., Aragon-Fernandez, P., Üresin, N. et al.
"Exploration of cell state heterogeneity using single-cell proteomics
through sensitivity-tailored data-independent acquisition."
Nat Commun 14, 5910 (2023).
(\href{https://doi.org/10.1038/s41467-023-41602-1}{link to article}).
}
\keyword{datasets}
