% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_pie.R
\name{PAC_pie}
\alias{PAC_pie}
\title{Pie plot from PAC}
\usage{
PAC_pie(
  PAC,
  anno_target = NULL,
  pheno_target = NULL,
  colors = NULL,
  norm = "counts",
  labels = "all",
  no_anno = TRUE,
  summary_target = NULL,
  angle = -25
)
}
\arguments{
\item{PAC}{PAC-list object.}

\item{anno_target}{List with: 
1st object being character vector of target
column(s) in Anno, 2nd object being a character
vector of the target biotype(s) in the target column
(1st object). Important, the 2nd object is order
sensitive, meaning that categories will appear in
the same order in the pie. (default=NULL)}

\item{pheno_target}{List with: 
1st object being character vector of target
column(s) in Pheno, 2nd object being a character
vector of the target group(s) in the target column
(1st object). Important, the 2nd object is order
sensitive, meaning that categories will appear in
the same order in the pie. (default=NULL)}

\item{colors}{Character vector RGB color codes as generated by for example
grDevices::colorRampPalette. If colors=NULL (default), colors will be
generated using a default color palette. Important: In default mode,
categories named "other" or no_anno" will automatically receive a grey
color.}

\item{norm}{Character vector defining what normalized data to plot. 
(default="counts")}

\item{labels}{Character that sets what labels to plot in the actual pie
besides the legend. If lables="all" (default), then the anno_target variables will be
combined with percentage. If lables="percent" only percentages will be
plotted with the pie. If labels="none", no lables will be present
besides the legend.}

\item{no_anno}{Logical whether PAC sequences without an annotation should be
removed prior to plotting. Specifically, if no_anno=FALSE, then sequences
annotated with "no_anno" in the anno_target column will be removed prior to
plotting. When no_anno=TRUE (default), then all sequences will be included
(unless excluded in the anno_target object).}

\item{summary_target}{List with 1st object being a character of which summary
to use, produced by \code{PAC_summary}. (default=NULL)}

\item{angle}{Integer (positive or negative) that sets the rotation of
the pie.}
}
\value{
A pie plot
}
\description{
\code{PAC_pie} Pie chart of annotation features (anno_target).
}
\details{
Given a PAC object the function will summarize the counts into percent
of a specified anno_target and plot a pie chart.
}
\examples{


##########################################
### Pie charts in seqpac 
##----------------------------------------

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

# Choose an anno_target and plot all samples (deafult):
output_pie <- PAC_pie(pac, anno_target=list("Biotypes_mis0"))
output_pie[[1]]
output_pie[[6]]

# Defining a summary_target will show summarised data:
pac<-PAC_summary(pac)
PAC_pie(pac, anno_target=list("Biotypes_mis0"), 
summary_target=list("countsMeans_All"))
# Rotate:
PAC_pie(pac, anno_target=list("Biotypes_mis0"), 
summary_target=list("countsMeans_All"), angle=180)


#  Make ordered pie charts of grand mean percent of all samples
ord_bio <- as.character(sort(unique(anno(pac)$Biotypes_mis3)), 
                                    unique(anno(pac)$Biotypes_mis0))
output_pie_1 <- PAC_pie(pac, anno_target=list("Biotypes_mis0", ord_bio), 
                        labels = "percent", summary_target=list("countsMeans_All"))
output_pie_2 <- PAC_pie(pac, anno_target=list("Biotypes_mis3", ord_bio), 
                        labels = "percent", summary_target=list("countsMeans_All"))
cowplot::plot_grid(plotlist=c(output_pie_1, output_pie_2), nrow=2, 
                   scale = 1.0)

#  Shortcut to remove no annotations ("no_anno") in the anno_target column
PAC_pie(pac, anno_target=list("Biotypes_mis3"), summary_target=list("countsMeans_All"),
 no_anno=TRUE)
PAC_pie(pac, anno_target=list("Biotypes_mis3"), summary_target=list("countsMeans_All"), 
no_anno=FALSE)

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
