% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_generics_methods.R
\docType{methods}
\name{counts}
\alias{counts}
\alias{counts,}
\alias{counts<-}
\alias{counts,PAC-method}
\alias{counts<-,PAC,data.frame-method}
\title{counts(PAC)}
\usage{
counts(object)

\S4method{counts}{PAC}(object)

\S4method{counts}{PAC,data.frame}(object) <- value
}
\arguments{
\item{object}{A S4 PAC-object containing Pheno, Anno and Counts tables. Can
be generated by the 'PAC generation' family of functions, for example see
?make_counts.}

\item{value}{Data.frame having the same column names as row names in Pheno
(sample ID) and row names as row names in Anno (sequences).}
}
\value{
The Counts data frame table from a PAC-object.

Updated S4 PAC-object.
}
\description{
Access the raw counts table in S4 PAC
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

# extra fuctionality with s4 PAC-object:
names(pac)
length(pac)
nrow(pac)
ncol(pac)
rownames(pac)
colnames(pac)
pheno(pac) 
head(anno(pac))
head(counts(pac))
head(norm(pac)$cpm)


}
\seealso{
Other PAC methods: 
\code{\link{anno}()},
\code{\link{names,PAC-method}},
\code{\link{norm}()},
\code{\link{pheno}()},
\code{\link{show.PAC}()},
\code{\link{summary}()}
}
\concept{PAC methods}
