% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ABSSeq}
\alias{ABSSeq}
\title{Differential expression analysis based on the total counts difference.}
\usage{
ABSSeq(object, adjmethod = "BH", replaceOutliers = TRUE, useaFold = FALSE,
  quiet = FALSE, ...)
}
\arguments{
\item{object}{an \code{\link{ABSDataSet}} object, contains the reads count matrix, groups and normalization method.}

\item{adjmethod}{defualt is 'BH', method for p-value adjusted, see \code{\link{p.adjust.methods}} for details}

\item{replaceOutliers}{default is TRUE, switch for outlier replacement.}

\item{useaFold}{defualt is FALSE, switch for DE detection through fold-change, see \code{\link{callDEs}} for details}

\item{quiet}{default is FALSE, whether to print messages at each step}

\item{...}{parameters passed to \code{\link{ReplaceOutliersByMAD}} and \code{\link{genAFold}} from \code{\link{callParameter}}}
}
\value{
an ABSDataSet object with additional elements, which can be retrieved by \code{\link{results}}:
Amean and Bmean, mean of log2 normalized reads count for group A and B, 
foldChange, shrinked (expression level and gene-specific) log2 of fold-change, B - A, 
rawFC, raw log2 of fold-change, B-A (without shrinkage),
lowFC, expression level corrected log2 fold-change,
pvalue, pvalue from NB distribution model, 
adj.pvalue, adjuested p-value used p.adjust method.
}
\description{
This function performs a default analysis by calling, in order, the functions:
\code{\link{normalFactors}},
\code{\link{callParameter}},
\code{\link{callDEs}}.
}
\details{
The differential expression analysis models the total counts difference by a Negative binomal distribution \deqn{NB(\mu,r)}:
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- ABSSeq(obj)
res <- results(obj,c("Amean","Bmean","foldChange","pvalue","adj.pvalue"))
head(res)
}
\references{
Wentao Yang, Philip Rosenstiel & Hinrich Schulenburg: ABSSeq: a new RNA-Seq analysis method based on modelling absolute expression differences
}
\author{
Wentao Yang
}
