% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{comp_NB_residuals}
\alias{comp_NB_residuals}
\title{Compute Negative-Binomial residuals}
\usage{
comp_NB_residuals(mat, theta = 100, clip = FALSE, cutoff = NULL, freq = TRUE)
}
\arguments{
\item{mat}{A numerical matrix or coercible to one by `as.matrix()`.
Should have row and column names.}

\item{theta}{Overdispersion parameter. By default set to 100 as described in
Lause and Berens, 2021 (see references).}

\item{clip}{logical. Whether residuals should be clipped if they are
higher/lower than a specified cutoff}

\item{cutoff}{numeric. Residuals that are larger than cutoff or lower than
-cutoff are clipped to cutoff.}

\item{freq}{logical. Whether a table of frequencies (as used in CA) should
be used.}
}
\value{
A named list. The elements are:
\itemize{
\item "S": standardized residual matrix.
\item "tot": grand total of the original matrix.
\item "rowm": row masses.
\item "colm": column masses.
}
}
\description{
Computes the residuals based on the negative binomial model. By default a
theta of 100 is used to capture technical variation.
}
\references{
Lause, J., Berens, P. & Kobak, D. Analytic Pearson residuals for
normalization of single-cell RNA-seq UMI data. Genome Biol 22, 258 (2021).
https://doi.org/10.1186/s13059-021-02451-7
}
