% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{run_cacomp}
\alias{run_cacomp}
\title{Internal function for `cacomp`}
\usage{
run_cacomp(
  obj,
  coords = TRUE,
  princ_coords = 3,
  python = FALSE,
  dims = 100,
  top = 5000,
  inertia = TRUE,
  rm_zeros = TRUE,
  residuals = "pearson",
  cutoff = NULL,
  clip = FALSE,
  ...
)
}
\arguments{
\item{obj}{A numeric matrix or Seurat/SingleCellExperiment object. For
sequencing a count matrix, gene expression values with genes in rows and
samples/cells in columns.
Should contain row and column names.}

\item{coords}{Logical. Indicates whether CA standard coordinates should be
calculated.}

\item{princ_coords}{Integer. Number indicating whether principal
coordinates should be calculated for the rows (=1), columns (=2),
both (=3) or none (=0).}

\item{python}{DEPRACTED. A logical value indicating whether to use singular-value
decomposition from the python package torch.
This implementation dramatically speeds up computation compared to `svd()`
in R when calculating the full SVD. This parameter only works when dims==NULL
or dims==rank(mat), where caculating a full SVD is demanded.}

\item{dims}{Integer. Number of CA dimensions to retain. If NULL:
(0.2 * min(nrow(A), ncol(A)) - 1 ).}

\item{top}{Integer. Number of most variable rows to retain.
Set NULL to keep all.}

\item{inertia}{Logical. Whether total, row and column inertias should be
calculated and returned.}

\item{rm_zeros}{Logical. Whether rows & cols containing only 0s should be
removed. Keeping zero only rows/cols might lead to unexpected results.}

\item{residuals}{character string. Specifies which kind of residuals should
be calculated. Can be "pearson" (default), "freemantukey" or "NB" for
negative-binomial.}

\item{cutoff}{numeric. Residuals that are larger than cutoff or lower than
-cutoff are clipped to cutoff.}

\item{clip}{logical. Whether residuals should be clipped if they are
higher/lower than a specified cutoff}

\item{...}{Arguments forwarded to methods.}
}
\value{
Returns a named list of class "cacomp" with components
U, V and D: The results from the SVD.
row_masses and col_masses: Row and columns masses.
top_rows: How many of the most variable rows/genes were retained for the
analysis.
tot_inertia, row_inertia and col_inertia: Only if inertia = TRUE. Total,
row and column inertia respectively.
}
\description{
`run_cacomp` performs correspondence analysis on a matrix and returns the
transformed data.
}
\details{
The calculation is performed according to the work of Michael Greenacre.
When working with large matrices,
CA coordinates and
principal coordinates should only be computed when needed to save
computational time.
}
\references{
Greenacre, M. Correspondence Analysis in Practice, Third Edition, 2017.
}
