% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_methods.R
\name{show.cacomp}
\alias{show.cacomp}
\alias{show,cacomp-method}
\title{Prints cacomp object}
\usage{
show.cacomp(object)

\S4method{show}{cacomp}(object)
}
\arguments{
\item{object}{cacomp object to print}
}
\value{
prints summary information about cacomp object.
}
\description{
Provides more user friendly printing of cacomp objects.
}
\examples{
# Simulate scRNAseq data.
cnts <- data.frame(cell_1 = rpois(10, 5),
                   cell_2 = rpois(10, 10),
                   cell_3 = rpois(10, 20))
rownames(cnts) <- paste0("gene_", 1:10)
cnts <- as.matrix(cnts)

# Run correspondence analysis.
ca <- cacomp(obj = cnts, princ_coords = 3, top = 5)

ca
}
