% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{binning}
\alias{binning}
\title{Binning/Bucketing of NMR spectra}
\usage{
binning(
  spectra,
  bin = 0.01,
  exclusion.areas = matrix(c(4.5, 5.1), ncol = 2),
  normalisation = TRUE,
  low.lim = 0.5,
  high.lim = 10,
  ncores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{spectra}{Data frame with spectra in columns and chemical shifts in
rows. Colnames of this data frame correspond to sample names and
rownames to chemical shift grid (in ppm).}

\item{bin}{Numeric value specifying the bin width.}

\item{exclusion.areas}{Definition domain of spectra that have to be excluded
of the analysis (ppm). By default, the water region is excluded
(4.5-5.1 ppm).}

\item{normalisation}{Logical. If \code{TRUE} a normalisation is applied for
each spectrum (see \code{\link{normaliseSpectra}} for details). Default to
\code{TRUE}.}

\item{low.lim, high.lim}{low and high chemical shift limits for the output bins
(default values : \code{low.lim = 0.5} and \code{high.lim = 10}).}

\item{ncores}{Number of cores used in parallel evaluation. Default to
\code{1}.}

\item{verbose}{A boolean value to allow print out process information.}

\item{...}{Further arguments to be passed to the function
\code{\link{normaliseSpectra}}}
}
\value{
A data frame with normalised spectra in columns and buckets in rows
(bucket names correspond to the center of the bucket).
}
\description{
Apply a binning function on a spectrum.
}
\examples{
current_path <- system.file("extdata", package = "ASICS")
spectra_data <- importSpectra(name.dir = current_path,
                     name.file = "spectra_example.txt", type.import = "txt")
spectra_bin <- binning(spectra_data, bin = 0.01, type.norm = "pqn")
}
