% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelation.R
\name{plotCorrelation}
\alias{plotCorrelation}
\title{plot Correlations of multiple samples}
\usage{
plotCorrelation(
  objs,
  txs,
  seqlev = intersect(seqlevels(objs[[1]]), seqlevels(txs)),
  upstream = 2000,
  downstream = 500,
  type = c("heatmap", "PCA"),
  ...
)
}
\arguments{
\item{objs}{an object of \link[GenomicAlignments:GAlignmentsList-class]{GAlignmentsList}}

\item{txs}{GRanges of transcripts}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{upstream}{numeric(1) or integer(1). Start position of promoter. Default is 2000}

\item{downstream}{numeric(1) or integer(1). End position of promoter. Default is 500}

\item{type}{Figure type, heatmap or PCA plot.}

\item{...}{parameters could be passed to downstream functions such as plot for pca or heatmap for heatmap.}
}
\value{
A invisible object of \link[GenomicRanges:GRanges-class]{GRanges} with counts
}
\description{
plot PCA or heatmap for multiple bamfiles. The correlation is 
calculated by the counts in promoter regions.
}
\details{
The correlation will be calculated by the correlation of insertion
sites within promoter regions. Even the sequencing is paired-end, 
please treat it as single ends.
}
\examples{
library(GenomicRanges)
library(GenomicAlignments)
path <- system.file("extdata", package="ATACseqQC", mustWork=TRUE)
bamfiles <- dir(path, "*.bam$", full.name=TRUE)
gals <- lapply(bamfiles, function(bamfile){
               readBamFile(bamFile=bamfile, tag=character(0), 
                           which=GRanges("chr1", IRanges(1, 1e6)), 
                           asMates=FALSE)
        })
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txs <- transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)
plotCorrelation(GAlignmentsList(gals), txs, seqlev="chr1")
}
\author{
Jianhong Ou
}
