% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareBindingSites.R
\name{reduceByPercentage}
\alias{reduceByPercentage}
\title{Reduce by percentage of overlaps of GRanges object}
\usage{
reduceByPercentage(
  query,
  percentage,
  ignore.strand = TRUE,
  colnToKeep = c("score", "motif")
)
}
\arguments{
\item{query}{An object of GRanges}

\item{percentage}{A numeric vector (length=1).
The percentage of overlapping region of binding sites to merge as one
range.}

\item{ignore.strand}{When set to TRUE, the strand information is ignored in
the calculations.}

\item{colnToKeep}{The metadata colnums should be kept for reduced GRanges}
}
\value{
An object of GRanges.
}
\description{
Merge the ranges by percentage of overlaps to avoid
broad ranges of continues ranges overlapped with limit bases.
}
\examples{
library(GenomicRanges)
gr <- GRanges("chr1", IRanges(c(1, 5, 10), width=c(10, 5, 2)))
reduceByPercentage(gr, 0.5, colnToKeep=NULL)
}
