#' Sample PSM Data from FragPipe
#'
#' This data frame represents sample peptide spectrum matches (PSMs) mapped to
#' the proteins A0AV96, A0AVF1, A0AVT1, A0FGR8, and A0M8Q6, obtained from the
#' search results of FragPipe. Columns unnecessary for the AWAggregator have
#' been removed from the sample data.
#'
#' @docType data
#' @format A data frame with 118 rows and 20 variables:
#' \describe{
#'   \item{Peptide}{Peptide amino acid sequence}
#'   \item{Charge}{The charge state of the identified peptide}
#'   \item{Calibrated Observed Mass}{Mass of the identified peptide after m/z
#'   calibration (in Da)}
#'   \item{Calibrated Observed M/Z}{Mass-to-charge ratio of the peptide ion
#'   after m/z calibration}
#'   \item{Delta Mass}{Difference between calibrated observed peptide mass and
#'   theoretical peptide mass (in Da)}
#'   \item{Hyperscore}{The similarity score between observed and theoretical
#'   spectra}
#'   \item{Number of Missed Cleavages}{Number of potential enzymatic cleavage
#'   sites within the identified sequence}
#'   \item{Intensity}{Raw integrated precursor abundance for each PSM}
#'   \item{Assigned Modifications}{Post-translational modifications within the
#'   identified sequence}
#'   \item{Purity}{The proportion of total ion abundance in the inclusion
#'   window from the precursor}
#'   \item{Protein}{Protein sequence header corresponding to the identified
#'   peptide sequence}
#'   \item{Sample 1, Sample 2, Sample 3, Sample 4, Sample 5, Sample 6,
#'   Sample 7, Sample 8, Sample 9}{Processed reporter ion intensities from
#'   sample 1 to 9}
#' }
#' @usage data(sample.PSM.FP)
#'
'sample.PSM.FP'
