% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-methods.R
\docType{methods}
\name{ASEset-filters}
\alias{ASEset-filters}
\alias{hetFilt}
\alias{hetFilt,ASEset-method}
\title{genotype filter methods}
\usage{
hetFilt(x, ...)

\S4method{hetFilt}{ASEset}(x, source = "genotype", ...)
}
\arguments{
\item{x}{ASEset object}

\item{...}{internal param}

\item{source}{'genotype' or 'alleleCounts'}
}
\description{
useful genotype filters
}
\details{
hetFilt returns TRUE if the samples is heterozygote, based on stored genotype information
present in the phase data.
}
\examples{

#load example data
data(ASEset)
a <- ASEset

genotype(a) <- inferGenotypes(a)
hets <- hetFilt(a) 

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{filter}
