% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_MTBLS242.R
\name{download_MTBLS242}
\alias{download_MTBLS242}
\title{Download MTBLS242}
\usage{
download_MTBLS242(
  dest_dir = "MTBLS242",
  force = FALSE,
  keep_only_CPMG_1r = TRUE,
  keep_only_preop_and_3months = TRUE,
  keep_only_complete_time_points = TRUE
)
}
\arguments{
\item{dest_dir}{Directory where the dataset should be saved}

\item{force}{Logical. If \code{TRUE} we do not re-download files if they exist. The function does not check whether cached versions were
downloaded with different \verb{keep_only_*} arguments, so please use \code{force = TRUE} if you change the \verb{keep_only_*} settings.}

\item{keep_only_CPMG_1r}{If \code{TRUE}, remove all other data beyond the CPMG real spectrum, which is enough for the tutorial}

\item{keep_only_preop_and_3months}{If \code{TRUE}, keep only the preoperatory and the "three months after surgery" time points, enough for the tutorial}

\item{keep_only_complete_time_points}{If \code{TRUE}, remove samples that do not appear on all timepoints. Useful for the tutorial.}
}
\value{
Invisibly, the annotations. See the example for how to download the
annotations and create a dataset from the downloaded files.
}
\description{
Downloads the \href{https://www.ebi.ac.uk/metabolights/MTBLS242/protocols}{MTBLS242}
dataset from Gralka et al., 2015. DOI: \doi{10.3945/ajcn.115.110536}.
}
\details{
Besides the destination directory, this function
includes three logical parameters to limit the amount of downloaded/saved data.
To run the tutorial workflow:
\itemize{
\item only the "preop" and "three months" timepoints are used,
\item only subjects measured in \emph{both} preop and three months time points are used
\item only the CPMG samples are used.
}

If you want to run the tutorial, you can set those filters to \code{TRUE}. Then, roughly
800MB will be downloaded, and 77MB of disk space will be used, since for each
downloaded sample we remove all the data but the CPMG.

If you set those filters to \code{FALSE}, roughly 1.8GB of data will be
downloaded (since we have more timepoints to download) and 1.8GB
of disk space will be used.

Note that we have experienced some sporadic timeouts from Metabolights,
when downloading the dataset. If you get those timeouts simply re-run the
download function and it will restart from where it stopped.

Note as well, that we observed several files to have incorrect data:
\itemize{
\item Obs4_0346s.zip is not present in the FTP server
\item Obs0_0110s.zip and Obs1_0256s.zip incorrectly contain sample Obs1_0010s
}

This function removes all three samples from the samples annotations and
doesn't download their data.
}
\examples{
\dontrun{
  download_MTBLS242("./MTBLS242")
  annot <- readr::read_tsv(annotations_destfile)
  
  dataset <- nmr_read_samples(annot$filename)
  dataset <- nmr_meta_add(dataset, annot)
  dataset
}
}
