% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_avworkspace-methods.R
\name{has_avworkspace-methods}
\alias{has_avworkspace-methods}
\alias{has_avworkspace,missing-method}
\alias{has_avworkspace,ANY-method}
\title{The \code{has_avworkspace} methods for \code{missing} and \code{ANY} signatures.}
\usage{
\S4method{has_avworkspace}{missing}(strict = FALSE, ..., platform)

\S4method{has_avworkspace}{ANY}(strict = FALSE, ..., platform)
}
\arguments{
\item{strict}{\code{logical(1)} Whether to include a check for an existing
\code{avworkspace_name()} setting. Default \code{FALSE}.}

\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
Methods for the 'missing' and 'ANY' signatures provide a way to
redirect calls to the appropriate method for the current cloud platform.
}
\description{
The \code{AnVILBase} package defines S4 methods for the AnVIL
package. These methods are defined for the 'missing' and 'ANY' signatures.
}
\section{Functions}{
\itemize{
\item \code{has_avworkspace(missing)}: Check whether the current
workspace is using either Azure or Google infrastructure.

\item \code{has_avworkspace(ANY)}: Check whether the current
workspace is using either Azure or Google infrastructure.

}}
\examples{
findMethods("has_avworkspace")
getMethod("has_avworkspace", c(platform = "missing"))

}
