% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avnotebooks-methods.R
\name{avnotebooks-methods}
\alias{avnotebooks-methods}
\alias{avnotebooks}
\alias{avnotebooks_localize}
\alias{avnotebooks_delocalize}
\alias{avnotebooks,gcp-method}
\alias{avnotebooks_localize,gcp-method}
\alias{avnotebooks_delocalize,gcp-method}
\title{Notebook management}
\usage{
\S4method{avnotebooks}{gcp}(
  local = FALSE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)

\S4method{avnotebooks_localize}{gcp}(
  destination,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  dry = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avnotebooks_delocalize}{gcp}(
  source,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  dry = TRUE,
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{local}{= \code{logical(1)} notebooks located on the workspace
(\code{local = FALSE}, default) or runtime / local instance (\code{local = TRUE}). When \code{local = TRUE}, the notebook path is
\verb{<avworkspace_name>/notebooks}.}

\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{...}{Additional arguments passed to lower level functions (not used).}

\item{platform}{\code{gcp()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"gcp"} class for Google Cloud Platform
workspaces on AnVIL.}

\item{destination}{missing or character(1) file path to the local
file system directory for synchronization. The default location
is \verb{~/<avworkspace_name>/notebooks}. Out-of-date local files
are replaced with the workspace version.}

\item{dry}{\code{logical(1)}, when \code{TRUE} (default), return the
consequences of the operation without actually performing the
operation.}

\item{source}{missing or character(1) file path to the local file
system directory for synchronization. The default location is
\verb{~/<avworkspace_name>/notebooks}. Out-of-date local files are
replaced with the workspace version.}
}
\value{
\code{avnotebooks()} returns a character vector of buckets /
files located in the workspace 'Files/notebooks' bucket path,
or on the local file system.

\code{avnotebooks_localize()} returns the exit status of
\code{gsutil_rsync()}.

\code{avnotebooks_delocalize()} returns the exit status of
\code{gsutil_rsync()}.
}
\description{
\code{avnotebooks()} returns the names of the notebooks
associated with the current workspace.
}
\section{Functions}{
\itemize{
\item \code{avnotebooks(gcp)}: List notebooks in the workspace

\item \code{avnotebooks_localize(gcp)}: Synchronizes the content of the workspace
bucket to the local file system.

\item \code{avnotebooks_delocalize(gcp)}: Synchronizes the content of the notebook
location of the local file system to the workspace bucket.

}}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = gcp())) {
    avnotebooks()
    avnotebooks_localize()  # dry run
    try(avnotebooks_delocalize())  # dry run, fails if no local resource
}
}
