\name{plotLogistic}
\alias{plotLogistic}
\title{Plot logistic model for sequins}
\description{
Create a scatter plot with input concentration on the x-axis, and measured
proportion on the y-axis.
}
\usage{
plotLogistic(seqs, x, y, title, xlab, ylab, showLOA, threshold)
}
\arguments{
  \item{seqs}{Sequin names}
  \item{x}{Expected input concentration on the x-axis}
  \item{y}{Measured proportion on the y-axis}
  \item{title}{Title of the plot. (Default to NULL).}
  \item{xlab}{Label for the x-axis. (Default to NULL).}
  \item{ylab}{Label for the y-axis. (Default to NULL).}
  \item{showLOA}{Display limit-of-assembly. (Default to TRUE).}
  \item{threshold}{Threshold required for limit-of-assembly (LOA). (Default to 0.7).}
}
\value{
The function returns the limit of quantification.
}
\details{
The \code{plotLogistic} function creates a scatter plot with input
concentration on the x-axis, and measured proportion on the y-axis. Common
measured statistics include p-value, percentage and sensitivity. The plot
builds a logistic regression model between the two variables.

The function also estimates limit-of-assembly (LOA) breakpoint, and reports it
on the plot if found. The LOA breakpoint is an empirical detection limit, and
also the abundance whereby the fitted logistic curve exceeds a user-defined
threshold.
}

\examples{
library(Anaquin)

#
# Data set generated by Cufflinks and Anaquin. described in Section 5.4.5.1 of
# the user guide.
#
data(UserGuideData_5.4.5.1)

title <- 'Assembly Plot'
xlab  <- 'Input Concentration (log2)'
ylab  <- 'Sensitivity'

# Sequin names
seqs <- row.names(UserGuideData_5.4.5.1)

# Input concentration
x <- log2(UserGuideData_5.4.5.1$Input)

# Measured sensitivity
y <- UserGuideData_5.4.5.1$Sn

plotLogistic(seqs, x, y, title=title, xlab=xlab, ylab=ylab, showLOA=TRUE)
}

\author{Ted Wong \email{t.wong@garvan.org.au}}